// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ input.cpp ]					Auter : KENSUKE WATANABE
//													Data  : 2016/08/29
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/08/29
//
// ======== ======== ======== ======== ======== ======== ======== ========
#include "InputMouse.h"

//=============================================================================
// }EX̏
//=============================================================================
HRESULT CInputMouse::Init(HINSTANCE hInstance, HWND hWnd)
{
	// ȅ(foCX̍쐬)
	CInput::Init(hInstance);

	// foCX̍쐬
	if (FAILED(m_pDInput->CreateDevice(GUID_SysMouse, &m_pDIDevice, nullptr)))
	{
		MessageBox(hWnd, "}EX˂I", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// f[^tH[}bgݒ
	if (FAILED(m_pDIDevice->SetDataFormat(&c_dfDIMouse2)))
	{
		MessageBox(hWnd, "}EX̃f[^tH[}bgݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// [hݒitHAOEhr[hj
	if (FAILED(m_pDIDevice->SetCooperativeLevel(hWnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE))))
	{
		MessageBox(hWnd, "}EX̋[hݒł܂łB", "xI", MB_ICONWARNING);
		return E_FAIL;
	}

	// }EXւ̃ANZXl(͐Jn) foCXɂĂ͉ɍsȂĂ͂Ȃ
	m_pDIDevice->Acquire();

	return S_OK;
}

//=============================================================================
// }EX̏I
//=============================================================================
void CInputMouse::Uninit(void)
{
	if (m_pDIDevice)
	{
		// }EXւ̃ANZXJ(͐I)
		m_pDIDevice->Unacquire();

		m_pDIDevice->Release();
		m_pDIDevice = nullptr;
	}
}

//=============================================================================
// }EX̍XV
//=============================================================================
void CInputMouse::Update(HWND hWnd)
{
	// }EXʒuXV
	m_PosOld.x = m_Pos.x;
	m_PosOld.y = m_Pos.y;
	GetCursorPos(&m_Pos);

	ScreenToClient(hWnd, &m_Pos);

	DIMOUSESTATE2 MouseState;

	// foCXf[^擾
	if (SUCCEEDED(m_pDIDevice->GetDeviceState(sizeof(DIMOUSESTATE2), &MouseState)))
	{
		m_PointMove = D3DXVECTOR2(static_cast<FLOAT>(MouseState.lX), static_cast<FLOAT>(MouseState.lY));
		for (int nCnt = 0; nCnt < 8; nCnt++)
		{
			// L[vXۑ
			m_aStateTrigger[nCnt] = (m_aState[nCnt] ^ MouseState.rgbButtons[nCnt]) & MouseState.rgbButtons[nCnt];	//gK[ۑ
			m_aStateRelease[nCnt] = (m_aState[nCnt] ^ MouseState.rgbButtons[nCnt]) & ~MouseState.rgbButtons[nCnt];	//[Xۑ

																													//L[s[g̐ (s&0x80)
			if (MouseState.rgbButtons[nCnt] & 0x80)
			{//L[Ă
				if (m_aStateRepeatCnt[nCnt] < COUNT_WAIT_REPEAT)
				{//s[gJEgɒBĂȂ
					m_aStateRepeatCnt[nCnt]++;
					if (m_aStateRepeatCnt[nCnt] == 1 || m_aStateRepeatCnt[nCnt] >= COUNT_WAIT_REPEAT)
					{//͂߂AɒBƂ
						m_aStateRepeat[nCnt] = MouseState.rgbButtons[nCnt];
					}
					else
					{//ɒB܂ł̊
						m_aStateRepeat[nCnt] = 0;
					}
				}
			}
			else
			{//L[ĂȂ
				m_aStateRepeat[nCnt] = 0;
				m_aStateRepeatCnt[nCnt] = 0;
			}
			m_aState[nCnt] = MouseState.rgbButtons[nCnt];	//݂̃L[ۑ
		}
	}
	else
	{//sĂANZXƂɂ
	 // }EXւ̃ANZX擾 
		m_pDIDevice->Acquire();
	}
}
